import { Switch, Route, Link, useLocation } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { TooltipProvider } from "@/components/ui/tooltip";
import { ThemeToggle } from "@/components/ThemeToggle";
import { Button } from "@/components/ui/button";
import VoiceTransformer from "@/pages/VoiceTransformer";
import BatchTransformer from "@/pages/BatchTransformer";
import NotFound from "@/pages/not-found";
import { AudioWaveform, Wand2, Files } from "lucide-react";

function Router() {
  return (
    <Switch>
      <Route path="/" component={VoiceTransformer} />
      <Route path="/batch" component={BatchTransformer} />
      <Route component={NotFound} />
    </Switch>
  );
}

function Navigation() {
  const [location] = useLocation();
  
  return (
    <nav className="flex items-center gap-1" data-testid="nav-mode-toggle">
      <Link href="/">
        <Button
          variant={location === "/" ? "default" : "ghost"}
          size="sm"
          className="gap-2"
          data-testid="nav-single"
        >
          <Wand2 className="h-4 w-4" />
          <span className="hidden sm:inline">Single</span>
        </Button>
      </Link>
      <Link href="/batch">
        <Button
          variant={location === "/batch" ? "default" : "ghost"}
          size="sm"
          className="gap-2"
          data-testid="nav-batch"
        >
          <Files className="h-4 w-4" />
          <span className="hidden sm:inline">Batch</span>
        </Button>
      </Link>
    </nav>
  );
}

function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <TooltipProvider>
        <div className="min-h-screen bg-background">
          <header className="sticky top-0 z-50 border-b bg-background/95 backdrop-blur supports-[backdrop-filter]:bg-background/60">
            <div className="max-w-6xl mx-auto px-4 h-14 flex items-center justify-between gap-4">
              <div className="flex items-center gap-3">
                <Link href="/">
                  <div className="flex items-center gap-3 cursor-pointer">
                    <div className="p-2 rounded-md bg-primary/10">
                      <AudioWaveform className="h-5 w-5 text-primary" />
                    </div>
                    <div>
                      <h1 className="text-lg font-semibold leading-tight">VoiceForge</h1>
                      <p className="text-xs text-muted-foreground hidden sm:block">
                        Advanced Voice Transformation
                      </p>
                    </div>
                  </div>
                </Link>
              </div>
              <div className="flex items-center gap-3">
                <Navigation />
                <ThemeToggle />
              </div>
            </div>
          </header>
          <main>
            <Router />
          </main>
        </div>
        <Toaster />
      </TooltipProvider>
    </QueryClientProvider>
  );
}

export default App;
